@extends('backend.master')

@section('title')
    {{ _trans('landlord.Dashboard') }}
@endsection

@section('content')
    <div class="page-content">
        <div class="row g-4">
            <div class="col-12">
                <div class="row">
                    <div class="dashboard-heading row align-items-center mb-10">
                        <div class="col-12 col-md-6 col-xl-6 col-lg-6">
                            <h3 class="title">{{ _trans('landlord.Hello') }} {{ Auth::user()->name }}</h3>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Dashboard Summery Card Start -->
            @if(Auth::user()->role_id === 1)
            <div class="col-12 summery-card">
                <div class="row g-4">
                    <div class="col-12 col-md-6 col-lg-6 col-xl-3 ">
                        <div class="card summery-card ot-card h-100 ">
                            <div class="card-heading d-flex align-items-center">
                                <div class="card-icon icon-circle-2">
                                    <i class="las la-users"></i>
                                </div>
                                <div class="card-content">
                                    <h4>{{ ___('common.Total Tenant') }}</h4>
                                    <h1>{{ withLeadingZero(@$landlord['total']) }}</h1>
                                </div>
                            </div>
                            <div class="card-bottom mt-20">
                                <div class="card-states">
                                    <div class="card-badge up">
                                        <img src="{{ asset('backend') }}/assets/images/icons/arrow-up.svg" alt="" />
                                        <span class="count">{{ withLeadingZero(@$landlord['active']) }}</span>
                                        <span class="status">{{ ___('common.active') }}</span>
                                    </div>
                                    <div class="card-badge down">
                                        <img src="{{ asset('backend') }}/assets/images/icons/arrow-donw.svg"
                                            alt="" />

                                        <span class="count">{{ withLeadingZero(@$landlord['inactive']) }}</span>
                                        <span class="status">{{ ___('common.inactive') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-6 col-xl-3 ">
                        <div class="card summery-card ot-card h-100 ">
                            <div class="card-heading d-flex">
                                <div class="card-icon icon-circle-3">

                                    <i class="las la-user-tag"></i>
                                </div>
                                <div class="card-content">
                                    <h4>{{ ___('common.Total Landlord') }}</h4>
                                    <h1>{{ withLeadingZero(@$tenant['total']) }}</h1>
                                </div>
                            </div>
                            <div class="card-bottom mt-20">
                                <div class="card-states">
                                    <div class="card-badge up">
                                        <img src="{{ asset('backend') }}/assets/images/icons/arrow-up.svg"
                                            alt="" />

                                        <span class="count">{{ withLeadingZero(@$tenant['active']) }}</span>
                                        <span class="status">{{ ___('common.active') }}</span>
                                    </div>

                                    <div class="card-badge down">
                                        <img src="{{ asset('backend') }}/assets/images/icons/arrow-donw.svg"
                                            alt="" />

                                        <span class="count">{{ withLeadingZero(@$tenant['inactive']) }}</span>
                                        <span class="status">{{ ___('common.inactive') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-6 col-xl-3 ">
                        <div class="card summery-card ot-card h-100 ">
                            <div class="card-heading d-flex">
                                <div class="card-icon icon-circle-1">

                                    <i class="las la-language"></i>
                                </div>
                                <div class="card-content">
                                    <h4>{{ ___('common.Total Properties') }}</h4>
                                    <h1>{{ withLeadingZero(@$property['total']) }}</h1>
                                   </div>
                            </div>
                            <div class="card-bottom mt-20">
                                <div class="card-states">
                                    <div class="card-badge up">
                                        <img src="{{ asset('backend') }}/assets/images/icons/arrow-up.svg"
                                            alt="" />

                                        <span class="count">{{ withLeadingZero(@$property['active']) }}</span>
                                        <span class="status">{{ ___('common.active') }}</span>
                                    </div>

                                    <div class="card-badge down">
                                        <img src="{{ asset('backend') }}/assets/images/icons/arrow-donw.svg"
                                            alt="" />

                                        <span class="count">{{ withLeadingZero(@$property['inactive']) }}</span>
                                        <span class="status">{{ ___('common.inactive') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-6 col-lg-6 col-xl-3">
                        <div class="card summery-card ot-card h-100 ">
                            <div class="card-heading d-flex">
                                <div class="card-icon icon-circle-4">

                                    <i class="las la-key"></i>
                                </div>
                                <div class="card-content">
                                    <h4>{{ ___('common.Total Blogs') }}</h4>
                                    <h1>{{ withLeadingZero(@$blogs['total']) }}</h1>
                                </div>
                            </div>
                            <div class="card-bottom mt-20">
                                <div class="card-states">
                                    <div class="card-badge up">
                                        <img src="{{ asset('backend') }}/assets/images/icons/arrow-up.svg"
                                            alt="" />

                                        <span class="count">{{ withLeadingZero(@$blogs['active']) }}</span>
                                        <span class="status">{{ ___('common.active') }}</span>
                                    </div>

                                    <div class="card-badge down">
                                        <img src="{{ asset('backend') }}/assets/images/icons/arrow-donw.svg"
                                            alt="" />

                                        <span class="count">{{ withLeadingZero(@$blogs['inactive']) }}</span>
                                        <span class="status">{{ ___('common.inactive') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @endif

            <!-- Dashboard Summery Card End -->
            <div class="col-12 statistic-card">
                <div class="row g-4">
                    <!-- Dashboard Statistic start  -->
                    <div class="ot-charts col-12 col-xxl-8">
                        <div class="card statistic-card ot-card">
                            <div class="card-header">
                                <div class="card-title">
                                    <h4>{{ ___('common.Transection') }}</h4>
                                </div>
                                <div class="dropdown card-button">
                                    <button class="btn btn-secondary ot-dropdown-btn dropdown-toggle" type="button"
                                        id="revenueBtn1" data-bs-toggle="dropdown" aria-expanded="false">
                                        <span>{{ _trans('landlord.last 07 days') }}</span>
                                        <i class="fa fa-chevron-down"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="revenueBtn1">
                                        <li>
                                            <a class="dropdown-item" href="#">{{ _trans('landlord.last 07 days') }}</a>
                                        </li>
                                        <li><a class="dropdown-item" href="#">{{ _trans('landlord.last month') }}</a>
                                        </li>
                                        <li><a class="dropdown-item" href="#">{{ _trans('landlord.last year') }}</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>

                            <div class="card-body">
                                <div id="revenueChart"></div>
                            </div>
                        </div>
                    </div>
                    <div class="ot-charts col-12 col-xxl-4">
                        <div class="card ot-card ot-visit-chart h-100">
                            <div class="card-header mb-20">
                                <div class="card-title">
                                    <h4>{{ ___('common.Overview') }}</h4>
                                </div>
                                <div class="dropdown card-button">
                                    <button class="btn btn-secondary ot-dropdown-btn dropdown-toggle" type="button"
                                        id="revenueBtn2" data-bs-toggle="dropdown" aria-expanded="false">
                                        <span>{{ _trans('landlord.last 07 days') }}</span>
                                        <i class="fa fa-chevron-down"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="revenueBtn2">
                                        <li>
                                            <a class="dropdown-item" href="#">{{ _trans('landlord.last 07 days') }}</a>
                                        </li>
                                        <li><a class="dropdown-item" href="#">{{ _trans('landlord.last month') }}</a>
                                        </li>
                                        <li><a class="dropdown-item" href="#">{{ _trans('landlord.last year') }}</a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <p>
                                <span class="ot-badge primary card-badge up">
                                <img src="../assets/images/icons/arrow-up.svg" alt=""/>36.8% </span> vs. Sep 8, 2021 visitor increased
                            </p>
                            <div class="card-body">
                                <div id="visited_customer_chart"></div>
                            </div>
                        </div>
                    </div>
                    <!-- Dashboard Statistic end  -->
                </div>
            </div>



        </div>
        <!-- table leave container end -->
    </div>
@endsection

@push('script')
    @include('backend.partials.delete-ajax')
    <script src="{{ asset('backend/assets/js/tables/export/excel.js') }}"></script>
    <script src="{{ asset('backend/assets/js/tables/export/pdf.js') }}"></script>
    <script src="{{ asset('backend/assets/js/tables/export/jspdf.js') }}"></script>
    <script src="{{ asset('backend/assets/js/tables/export/exportMethod.js') }}"></script>
    <script src="{{ asset('backend/assets/js/tables/export/__export.js') }}"></script>
    <script src="{{ asset('backend/assets/js/basic-datatable.js') }}"></script>
@endpush
